define([
    'backbone',
    'Layout',
    'modules/page/popup/external-nav-popup-view',
    'modules/notifications/notification-details-view',
],
function(Backbone, Layout, ExternalNavigationWarningPopup, NotificationDetailsView) {
    'use strict';

    describe('Notification Details View', function() {
        var view;
        var layout = new Layout();
        var model = new Backbone.Model({
            source: 'testSource',
            createDate: 1234,
            body: '<p>abcdefg <a href="https://vet.mobilehealthdemo.com/launchpad">launchpad</a></p>',
            readFlag: true,
        });

        layout.render();

        afterEach(function() {
            layout.getRegion('content').empty();
        });

        describe('', function() {
            beforeEach(function() {
                spyOn(ExternalNavigationWarningPopup.prototype, 'openPopup');

                spyOn(NotificationDetailsView.prototype, 'triggerDeleteModal');
                view = new NotificationDetailsView({model: model});
                layout.showChildView('content', view);
            });

            it('has button to return to appointments/requests', function() {
                var backButton = view.$el.find('#back-btn');
                expect(backButton.length).toEqual(1);
            });

            it("has a header that reads 'View Notification'", function() {
                var headerTitle = view.$el.find('h2')[0];
                expect(headerTitle.innerText.trim()).toEqual('View Notification');
            });

            it('reads out a properly formatted sent date', function() {
                var timeReadout = view.$el.find('#reminderSentTime')[0];
                // Should match 'MM/DD/YYYY @ HHmm' format
                expect(timeReadout.innerText.trim()).toMatch(/(0[1-9]|1[012])\/(0[1-9]|[12][0-9]|3[01])\/((19|20)\d\d)\s@\s([01][0-9]|2[0-3])[0-5][0-9]/);
            });

            it('has a delete button', function() {
                var deleteButton = view.$el.find('#delete-btn');
                expect(deleteButton.length).toEqual(1);
            });

            it('fires triggerDeleteModal() when the delete button is clicked', function() {
                var deleteButton = view.$el.find('#delete-btn');
                deleteButton.click();
                expect(view.triggerDeleteModal).toHaveBeenCalled();
            });

            it('shows a warning popup for external links in the notification text body', function() {
                view.$el.find('#notifications-detail a').click();
                expect(ExternalNavigationWarningPopup.prototype.openPopup).toHaveBeenCalled();
            });
        });

        describe("when the read flag is 'false'", function() {

            beforeEach(function() {
                model = new Backbone.Model({
                    source: 'testSource',
                    createDate: 1234,
                    body: '<p>abcdefg</p>',
                    readFlag: false,
                });

                spyOn(NotificationDetailsView.prototype, 'updateReadStatus');
                view = new NotificationDetailsView({model: model});
                layout.showChildView('content', view);
            });

            it("updates the read flag on the model and calls save on initialize() if the read flag was originally 'false'", function() {
                expect(view.updateReadStatus).toHaveBeenCalled();
            });

        });

        describe("when the read flag is 'true'", function() {

            beforeEach(function() {
                model = new Backbone.Model({
                    source: 'testSource',
                    createDate: 1234,
                    body: '<p>abcdefg</p>',
                    readFlag: true,
                });

                spyOn(NotificationDetailsView.prototype, 'updateReadStatus');
                view = new NotificationDetailsView({model: model});
                layout.showChildView('content', view);
            });

            it('it does not attempt to update the read flag', function() {
                expect(view.updateReadStatus).not.toHaveBeenCalled();
            });

        });
    });
}
);
